# -*- coding: iso-8859-1 -*-
#
# quakepy/fmd.py
# $Id: fmd.py 160 2009-02-17 14:26:53Z fab $
#
# The QuakePy package
# http://www.quakepy.org
#

############################################################################
#    Copyright (C) 2007-2009 by Fabian Euchner and Danijel Schorlemmer     #
#    fabian@fabian-euchner.de                                              #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

"""
The QuakePy package
http://www.quakepy.org
"""

__version__  = '$Id: fmd.py 160 2009-02-17 14:26:53Z fab $'
__revision__ = '$Revision: 160 $'
__author__   = "Fabian Euchner <fabian@fabian-euchner.de>, Danijel Schorlemmer <ds@usc.edu>"
__license__  = "GPL"

import numpy
import qpplot

class FrequencyMagnitudeDistribution( object ):
    
    def __init__( self, evpar, **kwargs ):

        self.binsize = 0.1
        
        if 'binsize' in kwargs.keys() and kwargs['binsize'] is not None:
            try:
                self.binsize = float( kwargs['binsize'] )
            except:
                pass
            
        curr_fmd = []
        self.fmd = []
        
        for curr_ev in evpar.event:
            
            curr_mag = curr_ev.getPreferredMagnitude().mag.value
            
            # append magnitude to list
            curr_fmd.append( float(curr_mag) )
        
        # sort list
        mag_sorted = numpy.array( sorted(curr_fmd) )
        del curr_fmd
        
        # get magnitude bins
        mag_start = numpy.floor( mag_sorted[0] - self.binsize )
        mag_end   = numpy.ceil( mag_sorted[-1] + self.binsize )
        mag_bins  = numpy.arange( mag_start, mag_end, self.binsize )
        
        # get histogram
        hist_n, hist_bins = numpy.histogram( mag_sorted, mag_bins )
        
        # get cumulative number
        cumul_no = []
        curr_cumul_no = 0
        
        for curr_idx in reversed( xrange( len(hist_bins) ) ):
            curr_cumul_no += int( hist_n[curr_idx] ) 
            cumul_no.append( curr_cumul_no )
            
        self.fmd = zip( hist_bins, hist_n, reversed(cumul_no) )
        del cumul_no
        
    def plot( self, imgfile, **kwargs ):
        
        # numpy.log10()
        if 'fmdtype' in kwargs.keys() and kwargs['fmdtype'] == 'cumulative':
            ord_idx = 2
        else:
            ord_idx = 1
            
        qpplot.QPPlot().plot( imgfile,
                              [ curr_data[0] for curr_data in self.fmd ], 
                              [ curr_data[ord_idx] for curr_data in self.fmd ], 
                              type='fmd' )
    
def main():
    pass
    
if __name__ == '__main__':
    main()
